/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.system;

import com.ibm.hwmca.base.managed.BaseTower;
import com.ibm.hwmca.fw.log.FrameworkClassLogInfo;
import com.ibm.hwmca.fw.log.FrameworkLog;
import com.ibm.hwmca.fw.managed.User;
import com.ibm.hwmca.fw.shutdown.ShutdownInProcessException;
import com.ibm.hwmca.fw.shutdown.ShutdownManager;
import com.ibm.hwmca.fw.system.LogoBean;
import com.ibm.hwmca.fw.system.Manager;
import com.ibm.hwmca.fw.system.RestartManager;
import com.ibm.hwmca.fw.system.StartupHook;
import com.ibm.hwmca.fw.task.TaskErrorIds;
import com.ibm.hwmca.fw.tasklet.PanelTasklet;
import com.ibm.hwmca.fw.tasklet.PanelTaskletRequest;
import com.ibm.hwmca.fw.tasklet.PanelTaskletResponse;
import com.ibm.hwmca.fw.tasklet.TaskletException;
import com.ibm.hwmca.fw.tasklet.impl.response.AddPanelDescriptorResponseData;
import com.ibm.hwmca.fw.tasklet.impl.response.DisposeResponseData;
import com.ibm.hwmca.fw.tasklet.impl.response.NoActionResponseData;
import com.ibm.hwmca.fw.tasklet.impl.response.OpenModalChildResponseData;
import com.ibm.hwmca.fw.tasklet.impl.response.RedirectResponseData;
import com.ibm.hwmca.fw.tasklet.impl.response.RemovePanelDescriptorResponseData;
import com.ibm.hwmca.fw.tasklet.impl.response.ReplaceResponseData;
import com.ibm.hwmca.fw.tasklet.impl.response.ResponseData;
import com.ibm.hwmca.fw.tasklet.impl.response.TerminateResponseData;
import com.ibm.hwmca.fw.util.LocalizableText;
import com.ibm.hwmca.fw.util.ManagePersistedObjects;
import com.ibm.hwmca.fw.util.Trace;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class StartupTasklet
extends PanelTasklet
implements TaskErrorIds {
    private static final String TRACE_MASKT = "XFRMLCTT";
    private static final String TRACE_MASKF = "XFRMLCTF";
    private static final String TRACE_MASKD = "XFRMLCTD";
    private static final String AUIML_FILE_NAME = "com.ibm.hwmca.fw.system.res.LogoRes";
    private static final String LOGO_PANEL = "LogoPanel";
    private static final String AUTOLOGON_CLASSNAME = "com.ibm.hwmca.fw.system.AutoLogon";
    private static final FrameworkClassLogInfo classLogInfo = new FrameworkClassLogInfo(85, "StrtupTklet");
    private List preInit = null;
    private List postInit = null;
    private int hookIndex = -1;
    private StartupHook currentHook = null;
    private boolean needNextHook = true;
    private boolean autoLogonDone = false;
    private int panelCount = 0;
    private boolean logoDestroyed = false;
    private int lastCompletionValue = 1;
    static /* synthetic */ Class class$com$ibm$hwmca$fw$tasklet$impl$response$ResponseData;
    static /* synthetic */ Class class$com$ibm$hwmca$fw$tasklet$PanelTasklet;

    public StartupTasklet() {
        Trace.trace(TRACE_MASKT, "<> StartupTasklet ctor");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void service(PanelTaskletRequest taskletRequest, PanelTaskletResponse taskletResponse) throws TaskletException {
        block42: {
            Trace.trace(TRACE_MASKT, "-> StartupTasklet.service()");
            try {
                if (taskletRequest.isInitialRequest()) {
                    Trace.trace(TRACE_MASKF, "it is the initial request");
                    this.setExplicitTerminate(true);
                    String performInit = System.getProperty("PERFORM_INIT", "YES");
                    if (performInit.equalsIgnoreCase("YES")) {
                        this.preInit = Manager.getManager().getTowerPreInitializationClassNames();
                        this.postInit = Manager.getManager().getTowerPostInitializationClassNames();
                        if (this.preInit == null) {
                            this.preInit = new ArrayList();
                        }
                        if (this.postInit == null) {
                            this.postInit = new ArrayList();
                        }
                        this.needNextHook = true;
                    } else {
                        Trace.trace(TRACE_MASKF, "skipping pre/post initialization hooks");
                        this.needNextHook = false;
                        this.currentHook = null;
                    }
                    LogoBean bean = new LogoBean();
                    bean.setBeanName("LOGO_BEAN");
                    taskletResponse.replace(AUIML_FILE_NAME, LOGO_PANEL, bean);
                    ++this.panelCount;
                    break block42;
                }
                if (this.needNextHook) {
                    Trace.trace(TRACE_MASKF, "we need the next hook");
                    if (this.panelCount > 1) {
                        Trace.trace(TRACE_MASKF, "the last hook has panels hanging out, so dispose of them");
                        taskletResponse.dispose();
                        --this.panelCount;
                        PanelTaskletRequest request = new PanelTaskletRequest();
                        request.setData("START_HOOK_PROCESSING", "START_HOOK_PROCESSING");
                        this.postRequest("LOGO_BEAN", request);
                        this.needNextHook = true;
                    } else {
                        this.getNextHook();
                        taskletRequest.setInitialRequest(true);
                        this.needNextHook = false;
                    }
                }
                boolean finished = false;
                while (!finished && this.currentHook != null && this.lastCompletionValue != 2 && this.lastCompletionValue != 3) {
                    PanelTaskletResponse tempResponse = new PanelTaskletResponse();
                    boolean hookException = false;
                    try {
                        this.currentHook.service(taskletRequest, tempResponse);
                    }
                    catch (Exception e) {
                        Trace.trace(TRACE_MASKF, "An exception occurred in a startup hook:");
                        Trace.trace(TRACE_MASKF, e);
                        hookException = true;
                    }
                    if (!hookException && tempResponse.isResponseSet()) {
                        Trace.trace(TRACE_MASKF, "the hook filled in a response");
                        boolean okResponse = true;
                        ResponseData data = tempResponse.getResponseData();
                        if (data instanceof OpenModalChildResponseData) {
                            ++this.panelCount;
                            Trace.trace(TRACE_MASKF, "the hook is opening a child window; incrementing the panel count");
                        } else if (data instanceof TerminateResponseData || data instanceof RedirectResponseData) {
                            okResponse = false;
                            Trace.trace(TRACE_MASKF, "the hook returned a terminate or redirect response");
                        } else if (this.panelCount == 1) {
                            if (data instanceof ReplaceResponseData || data instanceof DisposeResponseData || data instanceof NoActionResponseData || data instanceof RemovePanelDescriptorResponseData || data instanceof AddPanelDescriptorResponseData) {
                                okResponse = false;
                                Trace.trace(TRACE_MASKF, "the hook returned a response direcred for the logo panel");
                            }
                        } else if (data instanceof DisposeResponseData) {
                            --this.panelCount;
                            Trace.trace(TRACE_MASKF, "the hook is disposing a window; decrementing the panel count");
                        }
                        if (okResponse) {
                            Trace.trace(TRACE_MASKF, "the hook response was ok, so allow the response");
                            Class[] parms = new Class[]{class$com$ibm$hwmca$fw$tasklet$impl$response$ResponseData == null ? StartupTasklet.class$("com.ibm.hwmca.fw.tasklet.impl.response.ResponseData") : class$com$ibm$hwmca$fw$tasklet$impl$response$ResponseData};
                            Method method = StartupTasklet.getMethod(taskletResponse.getClass(), "setResponseData", parms);
                            boolean accessible = method.isAccessible();
                            method.setAccessible(true);
                            Object[] args = new Object[]{tempResponse.getResponseData()};
                            method.invoke((Object)taskletResponse, args);
                            method.setAccessible(accessible);
                            finished = true;
                            if (this.currentHook.getCompletionValue() == 0) continue;
                            PanelTaskletRequest request = new PanelTaskletRequest();
                            request.setData("START_HOOK_PROCESSING", "START_HOOK_PROCESSING");
                            this.postRequest("LOGO_BEAN", request);
                            this.needNextHook = true;
                            this.lastCompletionValue = this.currentHook.getCompletionValue();
                            this.currentHook = null;
                            continue;
                        }
                        Trace.trace(TRACE_MASKF, "the hook response was NOT ok, so DO NOT allow the response");
                        this.lastCompletionValue = 1;
                        if (this.panelCount > 1) {
                            Trace.trace(TRACE_MASKF, "the hook has panels hanging out, so dispose of them");
                            taskletResponse.dispose();
                            --this.panelCount;
                            finished = true;
                            PanelTaskletRequest request = new PanelTaskletRequest();
                            request.setData("START_HOOK_PROCESSING", "START_HOOK_PROCESSING");
                            this.postRequest("LOGO_BEAN", request);
                            this.needNextHook = true;
                            this.currentHook = null;
                            continue;
                        }
                        Trace.trace(TRACE_MASKF, "the hook does not have panels hanging out, so no need to dispose of them");
                        this.getNextHook();
                        taskletRequest.setInitialRequest(true);
                        continue;
                    }
                    this.lastCompletionValue = this.currentHook.getCompletionValue();
                    this.getNextHook();
                    taskletRequest.setInitialRequest(true);
                }
                if (this.lastCompletionValue != 2 && this.lastCompletionValue != 3) {
                    if (this.currentHook == null && !this.needNextHook) {
                        if (this.autoLogonDone) {
                            if (this.logoDestroyed) {
                                Trace.trace(TRACE_MASKF, "autologon done and logo destroyed.. terminating");
                                taskletResponse.terminate();
                            } else {
                                Trace.trace(TRACE_MASKF, "telling the logo bean that startup is complete");
                                HashMap<String, String> map = new HashMap<String, String>();
                                map.put("REQUEST_TYPE", "STARTUP_COMPLETE");
                                taskletResponse.update("LOGO_BEAN", map);
                                this.logoDestroyed = true;
                                if (this.preInit == null && this.postInit == null) {
                                    Thread.currentThread();
                                    Thread.sleep(3000L);
                                }
                            }
                        } else {
                            Trace.trace(TRACE_MASKF, "Checking auto logon settings");
                            BaseTower baseTower = BaseTower.getBaseTower();
                            ManagePersistedObjects.waitForRestore();
                            Object[] autoLogonData = null;
                            if (baseTower.isAutoLogonEnabled()) {
                                Trace.trace(TRACE_MASKF, "Auto logon is enabled");
                                String userid = baseTower.getAutoLogonUserid();
                                if (userid != null) {
                                    Trace.trace(TRACE_MASKF, "Auto logon userid is: " + userid + ".");
                                    User user = User.getUser(userid);
                                    if (user != null) {
                                        autoLogonData = new Object[]{userid, user.getPassword()};
                                    }
                                }
                            }
                            HashMap<String, Object> map = new HashMap<String, Object>();
                            map.put("REQUEST_TYPE", "RUN_ON_CLIENT");
                            Object[] objs = new Object[]{AUTOLOGON_CLASSNAME, autoLogonData};
                            map.put("REQUEST_DATA", objs);
                            taskletResponse.update("LOGO_BEAN", map);
                            Trace.trace(TRACE_MASKF, "Send auto logon request");
                            this.autoLogonDone = true;
                        }
                    }
                    break block42;
                }
                Trace.trace(TRACE_MASKF, "need to perform a hook restart");
                if (taskletResponse.isResponseSet()) break block42;
                try {
                    if (this.lastCompletionValue == 3) {
                        ShutdownManager.restartConsole(new LocalizableText("Startup"), null, null);
                    } else {
                        ShutdownManager.restartApplication(new LocalizableText("Startup"), null, null);
                    }
                }
                catch (ShutdownInProcessException e) {
                    Trace.trace(TRACE_MASKF, "shutdown is already in process");
                }
                finally {
                    Trace.trace(TRACE_MASKF, "StartupTasklet: terminating");
                    taskletResponse.terminate();
                }
            }
            catch (Exception e) {
                Trace.trace(TRACE_MASKF, "Exception during service: " + e);
                if (e instanceof TaskletException) {
                    throw (TaskletException)e;
                }
                throw new TaskletException(e);
            }
        }
        Trace.trace(TRACE_MASKT, "<- StartupTasklet.service()");
    }

    private StartupHook getNextHook() {
        Trace.trace(TRACE_MASKF, "-> StartupTasklet.getNextHook()");
        if (this.lastCompletionValue != 2 && this.lastCompletionValue != 3) {
            boolean tryAgain;
            RestartManager restartManager = RestartManager.getRestartManager();
            do {
                tryAgain = false;
                this.currentHook = null;
                ++this.hookIndex;
                String hookClassName = null;
                Trace.trace(TRACE_MASKF, "hook index is: " + this.hookIndex);
                if (this.hookIndex < this.preInit.size()) {
                    hookClassName = (String)this.preInit.get(this.hookIndex);
                } else {
                    if (this.hookIndex == this.preInit.size() && null == (hookClassName = restartManager.getPreInitStartupHook())) {
                        Manager.getManager().setPreInitDone(true);
                        Manager.getManager().waitForTowers();
                    }
                    if (null == hookClassName && this.hookIndex < this.preInit.size() + this.postInit.size()) {
                        hookClassName = (String)this.postInit.get(this.hookIndex - this.preInit.size());
                    }
                    if (null == hookClassName) {
                        hookClassName = restartManager.getPostInitStartupHook();
                    }
                }
                if (hookClassName == null) continue;
                try {
                    Trace.trace(TRACE_MASKF, "working on class[" + hookClassName + "]");
                    Class[] aClass = new Class[]{class$com$ibm$hwmca$fw$tasklet$PanelTasklet == null ? StartupTasklet.class$("com.ibm.hwmca.fw.tasklet.PanelTasklet") : class$com$ibm$hwmca$fw$tasklet$PanelTasklet};
                    Class<?> hookClass = Class.forName(hookClassName);
                    Constructor<?> ctor = hookClass.getConstructor(aClass);
                    Object[] args = new Object[]{this};
                    this.currentHook = (StartupHook)ctor.newInstance(args);
                }
                catch (Exception ex) {
                    Trace.trace(TRACE_MASKF, "exception occurred working on hook class");
                    new FrameworkLog(classLogInfo, 62, ex).log();
                    tryAgain = true;
                }
            } while (tryAgain);
        } else {
            Trace.trace(TRACE_MASKF, "Need to restart, skip getting the next hook");
            this.currentHook = null;
        }
        Trace.trace(TRACE_MASKF, "<- StartupTasklet.getNextHook()");
        return this.currentHook;
    }

    public void logException(Throwable throwable) {
        Trace.trace(TRACE_MASKT, "-> StartupTasklet.logException()");
        Trace.trace(TRACE_MASKT, "processing exception: " + throwable);
        new FrameworkLog(classLogInfo, 61, throwable).log();
        Trace.trace(TRACE_MASKT, "<- StartupTasklet.logException()");
    }

    private static Method getMethod(Class targetClass, String methodName, Class[] parameterTypes) throws NoSuchMethodException {
        for (Class cls = targetClass; cls != null; cls = cls.getSuperclass()) {
            try {
                Method method = cls.getDeclaredMethod(methodName, parameterTypes);
                return method;
            }
            catch (NoSuchMethodException e) {
                continue;
            }
        }
        throw new NoSuchMethodException(methodName);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

